#version 330

uniform mat4 view;
uniform mat4 viewproj;

in vec4 vertex;
in vec3 normal;
in vec2 uv0; //uv
#ifdef ONE_POSE_ANIMATION
in vec4 uv1; //Vertex animation pose data
in vec4 uv2; //world0
in vec4 uv3; //world1
in vec4 uv4; //world2
in vec4 uv5; //x: animation weight, y: 0, z: 0, w: packed texture index
#else
in vec4 uv1; //world0
in vec4 uv2; //world1
in vec4 uv3; //world2
in vec4 uv4; //x: 0, y: 0, z: 0, w: color index and texture index
#endif
#if TANGENT
in vec4 tangent;
#endif
in vec4 colour;

out vec4 pos;
out vec3 norm;
out vec2 uv;
out vec3 idx; //texIdx - dif, nor, asg
#if TANGENT
out vec3 tang;
out vec3 binorm;
#endif
out vec4 vcolor;

void main()
{
	mat3x4 worldT;
#if ONE_POSE_ANIMATION
	worldT[0] = uv2;
	worldT[1] = uv3;
	worldT[2] = uv4;
	vec4 worldPos = vec4(vec4(uv1.xyz*uv5.x + vertex.xyz, 1.0) * worldT, 1.0);
#else
	worldT[0] = uv1;
	worldT[1] = uv2;
	worldT[2] = uv3;
	vec4 worldPos = vec4(vertex * worldT, 1.0);
#endif
	vec3 worldNorm = normal * mat3(worldT);

	pos = view * worldPos;
	norm = mat3(view) * worldNorm;
	uv.xy = uv0.xy;
	
#if ONE_POSE_ANIMATION
	float difIdx = uv5.w;
#else
	float difIdx = uv4.w;
#endif

	float asgIdx = floor(difIdx/65536 + 0.5);
	difIdx -= asgIdx*65536;
	float norIdx = floor(difIdx/256 + 0.5);
	difIdx -= norIdx*256;
	idx = vec3(difIdx, norIdx, asgIdx);
	
#if TANGENT
	tang = tangent.xyz * mat3(worldT);
	tang = mat3(view) * tang;
	binorm = cross(norm, tang)*tangent.w;
#endif
	vcolor = colour;

	gl_Position = viewproj * worldPos;
}
